** NOTE: WRENCH framework sometimes has trouble running on Windows or Mac. Please switch to ubuntu machine if you encounter any problems whilst running on Windows or Mac. 

# RACH-Space codes for Weakly Supervised Learning
This repo contains code for RACH-Space, applied to weak supervision

# 1. Download Datasets
Download the 10 classification datasets provided by the WRENCH project

# 2. Create Conda Environment

## 2.1 Download WRENCH framework
Download the WRENCH framework provided by the WRENCH project

This is independent of RACH-Space's functionality, but it is useful for running experiments on real world datasets in the same environment as other weak supervision methods when comparing and reproducing the results.

## 2.2 (Alternative)
```
conda env create -f environment.yml
conda activate RACH_Space_exps
```
Alternatively, you can use the environment.yml file provided by WRENCH project
https://github.com/JieyuZ2/wrench to do so as well, as above.


# 3. Reproducing Experiment Results

Add utilities folder to path. It contains this file :
- RACH_Space_model.py

Add the following to /wrench/labelmodel :
- RACH_Space.py

Add the following to /wrench/examples :
- run_RACH_Space.py

```
python /wrench/examples/run_RACH_Space.py
```
This will give both the f1 and the accuracy score for RACH-Space applied to the corresponding dataset in WRENCH.


# 4. LICENSE
Our code is released under GNU GENERAL PUBLIC LICENSE Version 3. See the LICENSE file.

